<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Patient extends Eloquent {

	protected $table = 'patients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'phone', 'address', 'birth_date', 'gender', 'blood_category', 'doctor_id', 'image', 'notes');

	public function documents()
	{
		return $this->hasMany('Models\PatientDocument', 'patient_id');
	}

}