<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceItemsTable extends Migration {

	public function up()
	{
		Schema::create('invoice_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('item_id');
			$table->string('item_type')->nullable();
			$table->integer('inventory_id');
			$table->float('quantity')->default('0');
			$table->float('sale_price')->default('0');
			$table->integer('invoice_id');
			$table->float('total')->default('0');
			$table->integer('category_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice_items');
	}
}