<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->softDeletes();
			$table->text('name')->nullable();
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
			$table->text('address')->nullable();
			$table->date('birth_date')->nullable();
			$table->enum('gender', array('male', 'female', 'other'))->nullable();
			$table->integer('blood_category')->nullable();
			$table->integer('doctor_id')->nullable();
			$table->string('image')->nullable();
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}