<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Donor extends Eloquent {

	protected $table = 'donors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'name', 'phone', 'email', 'last_donation_date', 'date', 'age', 'gender');

	public function category()
	{
		return $this->belongsTo('Models\Category', 'category_id');
	}

}