<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Expense extends Eloquent {

	protected $table = 'expenses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'amount', 'date', 'notes');

	public function category()
	{
		return $this->belongsTo('Models\Category', 'category_id');
	}

}