<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Holiday extends Eloquent {

	protected $table = 'holidays';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('doctor_id', 'day', 'notes');

	public function doctor()
	{
		return $this->belongsTo('Models\Doctor', 'doctor_id');
	}

}