<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoiceItem extends Model 
{

    protected $table = 'invoice_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('item_id', 'item_type', 'inventory_id', 'quantity', 'sale_price', 'invoice_id', 'total', 'category_id');

    public function invoice()
    {
        return $this->belongsTo('Models\Invoice', 'invoice_id');
    }

}