<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBedsTable extends Migration {

	public function up()
	{
		Schema::create('beds', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id')->nullable();
			$table->string('number')->nullable();
			$table->text('notes')->nullable();
			$table->enum('status', array('active', 'not_active'));
		});
	}

	public function down()
	{
		Schema::drop('beds');
	}
}