<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLabReportsTable extends Migration {

	public function up()
	{
		Schema::create('lab_reports', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('patient_id');
			$table->integer('doctor_id');
			$table->date('date')->nullable();
			$table->longText('details')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('lab_reports');
	}
}