<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Schedule extends Eloquent {

	protected $table = 'schedule';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function type()
	{
		return $this->belongsTo('TypeActivity');
	}

	public function place()
	{
		return $this->belongsTo('Places', 'id_place');
	}

	public function location()
	{
		return $this->belongsTo('Locations');
	}

}