<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('id_place')->unsigned();
			$table->string('title', 255);
			$table->string('short_description', 255);
			$table->text('description');
			$table->string('address', 255);
			$table->decimal('lat');
			$table->decimal('long');
			$table->integer('id_type_activity')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}