<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('email');
			$table->string('phone_number');
			$table->string('phone_country_code');
			$table->string('uid');
			$table->date('dob');
			$table->string('profile_pic_url');
			$table->string('gender');
			$table->uuid('phyllo_user_id');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}