<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserSocialAccountsTable extends Migration {

	public function up()
	{
		Schema::create('user_social_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->string('username');
			$table->uuid('work_platform_id')->primary();
			$table->string('name');
			$table->string('uuid');
			$table->string('profile_pic_url');
			$table->string('status');
			$table->string('platform_profile_name');
			$table->string('platform_profile_id');
			$table->string('extras');
		});
	}

	public function down()
	{
		Schema::drop('user_social_accounts');
	}
}