<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeProfile extends Model 
{

    protected $table = 'profile_employee';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->morphTo();
    }

    public function branch()
    {
        return $this->hasOne('CompanyBranches', 'branch_id');
    }

}