<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AdminProfile extends Eloquent {

	protected $table = 'profile_administrator';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->morphTo();
	}

	public function branch()
	{
		return $this->hasOne('CompanyBranches', 'branch_id');
	}

}