<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('concept_user', function(Blueprint $table) {
			$table->foreign('concept_id')->references('id')->on('concepts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('concept_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('concept_user', function(Blueprint $table) {
			$table->dropForeign('concept_user_concept_id_foreign');
		});
		Schema::table('concept_user', function(Blueprint $table) {
			$table->dropForeign('concept_user_user_id_foreign');
		});
	}
}