<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Flat extends Eloquent {

	protected $table = 'flats';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('apartment_id', 'type', 'flat_number', 'squaremeter', 'number_of_rooms', 'price');

	public function apartment()
	{
		return $this->belongsTo('App\Models\Apartment', 'id', 'apartment_id');
	}

}