<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePeopleTable extends Migration {

	public function up()
	{
		Schema::create('people', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('flat_id')->unsigned()->nullable();
			$table->string('type', 50)->nullable();
			$table->string('name', 50)->nullable();
			$table->string('surname', 50)->nullable();
			$table->string('email', 50)->nullable();
			$table->string('phone', 50)->nullable();
			$table->boolean('is_resident')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('people');
	}
}