<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlatsTable extends Migration {

	public function up()
	{
		Schema::create('flats', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('apartment_id')->unsigned()->nullable();
			$table->integer('type')->nullable();
			$table->string('flat_number', 10)->nullable();
			$table->integer('squaremeter')->nullable();
			$table->string('number_of_rooms', 10)->nullable();
			$table->float('price')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('flats');
	}
}