<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('case', function(Blueprint $table) {
			$table->foreign('client_manager_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('trek_steps', function(Blueprint $table) {
			$table->foreign('trek_id')->references('id')->on('treks')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('case', function(Blueprint $table) {
			$table->dropForeign('case_client_manager_id_foreign');
		});
		Schema::table('trek_steps', function(Blueprint $table) {
			$table->dropForeign('trek_steps_trek_id_foreign');
		});
	}
}