<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttitudesTable extends Migration {

	public function up()
	{
		Schema::create('Attitudes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->bigInteger('relation_id')->unsigned();
			$table->bigInteger('name_id')->unsigned();
			$table->bigInteger('group_id')->unsigned();
			$table->bigInteger('value_id')->unsigned()->nullable();
			$table->bigInteger('audience_id')->unsigned();
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('Attitudes');
	}
}