<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateValuesTable extends Migration {

	public function up()
	{
		Schema::create('values', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->text('description');
			$table->bigInteger('relation_id')->unsigned();
			$table->bigInteger('audience_id')->unsigned();
			$table->boolean('has_scale')->default(1);
			$table->string('tyranny_value')->nullable();
			$table->string('loss_value')->nullable();
			$table->string('balanced_value')->nullable();
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('values');
	}
}