<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('books', function(Blueprint $table) {
			$table->foreign('publisher_id')->references('id')->on('publishers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employments', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_author_xref', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_author_xref', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('authors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_genre_xref', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_genre_xref', function(Blueprint $table) {
			$table->foreign('genre_id')->references('id')->on('genres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_preview_xref', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_preview_xref', function(Blueprint $table) {
			$table->foreign('preview')->references('id')->on('previews')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('books', function(Blueprint $table) {
			$table->dropForeign('books_publisher_id_foreign');
		});
		Schema::table('employments', function(Blueprint $table) {
			$table->dropForeign('employments_book_id_foreign');
		});
		Schema::table('book_author_xref', function(Blueprint $table) {
			$table->dropForeign('book_author_xref_book_id_foreign');
		});
		Schema::table('book_author_xref', function(Blueprint $table) {
			$table->dropForeign('book_author_xref_author_id_foreign');
		});
		Schema::table('book_genre_xref', function(Blueprint $table) {
			$table->dropForeign('book_genre_xref_book_id_foreign');
		});
		Schema::table('book_genre_xref', function(Blueprint $table) {
			$table->dropForeign('book_genre_xref_genre_id_foreign');
		});
		Schema::table('book_preview_xref', function(Blueprint $table) {
			$table->dropForeign('book_preview_xref_book_id_foreign');
		});
		Schema::table('book_preview_xref', function(Blueprint $table) {
			$table->dropForeign('book_preview_xref_preview_foreign');
		});
	}
}