<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'password', 'neighborhood_id');

    public function orders()
    {
        return $this->hasMany('App/Models\Order');
    }

    public function notifications()
    {
        return $this->morphMany('App/Models\Notification');
    }

    public function neighborhood()
    {
        return $this->belongsTo('App/Models\Neighborhood');
    }

    public function tokens()
    {
        return $this->morphMany('App/Models\Token', 'tokenable');
    }

    public function reviews()
    {
        return $this->hasMany('App/Models\Review');
    }

}