<?php

namespace App/Models;

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;
	protected $fillable = array('name', 'image', 'delivery', 'min_charge', 'email', 'phone', 'password', 'neighborhood_id');

	public function notifications()
	{
		return $this->morphMany('App/Models\Notification');
	}

	public function orders()
	{
		return $this->hasMany('App/Models\Order');
	}

	public function products()
	{
		return $this->hasMany('App/Models\Product');
	}

	public function reviews()
	{
		return $this->hasMany('App/Models\Review');
	}

	public function categories()
	{
		return $this->belongsToMany('App/Models\Category');
	}

	public function payments()
	{
		return $this->hasMany('App/Models\Commission');
	}

	public function tokens()
	{
		return $this->morphMany('App/Models\Token', 'tokenable');
	}

	public function neighborhood()
	{
		return $this->belongsTo('App/Models\Neighborhood');
	}

}