<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUCollectionsTable extends Migration {

	public function up()
	{
		Schema::create('u_collections', function(Blueprint $table) {
			$table->integer('cid', true);
			$table->integer('uid')->nullable();
			$table->string('title', 255)->default('''');
			$table->string('desc', 255);
			$table->string('tags', 255);
			$table->text('data')->nullable()->index();
			$table->integer('private');
			$table->integer('order')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('u_collections');
	}
}