<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWsTwitternewsTweetsTable extends Migration {

	public function up()
	{
		Schema::create('ws_twitternews_tweets', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('query_id')->unsigned();
			$table->integer('source_id')->unsigned()->nullable();
			$table->string('ref_id', 255);
			$table->text('text');
			$table->timestamp('created_at');
			$table->string('url', 255);
			$table->string('website', 255);
			$table->string('media_url', 255);
			$table->string('user_screen_name', 255);
			$table->string('user_profile_image_url', 255);
			$table->string('user_profile_bg', 255);
			$table->text('backup');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('ws_twitternews_tweets');
	}
}