<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWsWidgetsTable extends Migration {

	public function up()
	{
		Schema::create('ws_widgets', function(Blueprint $table) {
			$table->increments('id');
			$table->string('translation', 255);
			$table->text('description');
			$table->string('hurl', 255);
			$table->string('jurl', 255);
			$table->string('curl', 255);
			$table->text('data');
			$table->string('logo', 255);
			$table->string('button', 255);
			$table->integer('type')->default('0');
			$table->tinyInteger('open')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('ws_widgets');
	}
}