<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePhotosTable extends Migration {

	public function up()
	{
		Schema::create('photos', function(Blueprint $table) {
			$table->increments('id');
			$table->string('photo_name', 255)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('thumb', 255)->nullable();
			$table->string('model')->nullable();
			$table->string('objektiv', 255)->nullable();
			$table->string('viderjka', 255)->nullable();
			$table->string('focus', 255)->nullable();
			$table->string('iso', 255)->nullable();
			$table->string('aperture', 255)->nullable();
			$table->string('imageable_type', 255)->nullable();
			$table->integer('imageable_id')->unsigned()->nullable();
			$table->integer('photable_id')->unsigned()->nullable();
			$table->timestamps();
			$table->string('photable_type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('photos');
	}
}