<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('word', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lesson_word', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lesson')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lesson_word', function(Blueprint $table) {
			$table->foreign('word_id')->references('id')->on('word')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lesson_word', function(Blueprint $table) {
			$table->foreign('word_answer_id')->references('id')->on('word_answer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('word_answer', function(Blueprint $table) {
			$table->foreign('word_id')->references('id')->on('word')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('activity', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('relationship', function(Blueprint $table) {
			$table->foreign('following_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('relationship', function(Blueprint $table) {
			$table->foreign('follower_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('word', function(Blueprint $table) {
			$table->dropForeign('word_category_id_foreign');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->dropForeign('lesson_user_id_foreign');
		});
		Schema::table('lesson', function(Blueprint $table) {
			$table->dropForeign('lesson_category_id_foreign');
		});
		Schema::table('lesson_word', function(Blueprint $table) {
			$table->dropForeign('lesson_word_lesson_id_foreign');
		});
		Schema::table('lesson_word', function(Blueprint $table) {
			$table->dropForeign('lesson_word_word_id_foreign');
		});
		Schema::table('lesson_word', function(Blueprint $table) {
			$table->dropForeign('lesson_word_word_answer_id_foreign');
		});
		Schema::table('word_answer', function(Blueprint $table) {
			$table->dropForeign('word_answer_word_id_foreign');
		});
		Schema::table('activity', function(Blueprint $table) {
			$table->dropForeign('activity_user_id_foreign');
		});
		Schema::table('relationship', function(Blueprint $table) {
			$table->dropForeign('relationship_following_id_foreign');
		});
		Schema::table('relationship', function(Blueprint $table) {
			$table->dropForeign('relationship_follower_id_foreign');
		});
	}
}