<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('chapter_id')->unsigned();
			$table->integer('templateview_id')->unsigned();
			$table->enum('page_type', array(''index'', ''copy'', ''video'', ''quiz''));
			$table->string('quick_navigation', 255);
			$table->string('titel', 255);
			$table->string('slug');
			$table->string('subtitel', 255);
			$table->text('body');
			$table->string('view', 255);
			$table->string('css_class', 255);
			$table->text('footer');
			$table->text('expert');
			$table->text('list');
			$table->text('custom');
			$table->integer('order');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}