<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('school_id')->references('id')->on('schools')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user_details')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('throttle', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('throttle')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_achievements', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_achievements', function(Blueprint $table) {
			$table->foreign('achievement_id')->references('id')->on('achievements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('media', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('chapters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('chapters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('templateview_id')->references('id')->on('template_views')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('template_views', function(Blueprint $table) {
			$table->foreign('template_id')->references('id')->on('templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_school_id_foreign');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->dropForeign('user_details_user_id_foreign');
		});
		Schema::table('throttle', function(Blueprint $table) {
			$table->dropForeign('throttle_user_id_foreign');
		});
		Schema::table('user_achievements', function(Blueprint $table) {
			$table->dropForeign('user_achievements_user_id_foreign');
		});
		Schema::table('user_achievements', function(Blueprint $table) {
			$table->dropForeign('user_achievements_achievement_id_foreign');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->dropForeign('invites_user_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_course_id_foreign');
		});
		Schema::table('media', function(Blueprint $table) {
			$table->dropForeign('media_page_id_foreign');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->dropForeign('user_progress_user_id_foreign');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->dropForeign('user_progress_course_id_foreign');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->dropForeign('user_progress_lesson_id_foreign');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->dropForeign('user_progress_chapter_id_foreign');
		});
		Schema::table('user_progress', function(Blueprint $table) {
			$table->dropForeign('user_progress_page_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_chapter_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_templateview_id_foreign');
		});
		Schema::table('template_views', function(Blueprint $table) {
			$table->dropForeign('template_views_template_id_foreign');
		});
	}
}