<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccesServicesTable extends Migration {

	public function up()
	{
		Schema::create('acces_services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('label', array('USSD', 'Applicationmobile', 'Web', 'Carte', 'Agence', 'Distributeurautomatique'))->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('acces_services');
	}
}