<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComptesTable extends Migration {

	public function up()
	{
		Schema::create('comptes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('clientType', array('Particulier', 'Entrepriseindividuelle'))->nullable();
			$table->string('devise', 10)->nullable();
			$table->integer('client')->unsigned();
			$table->enum('objectif', array('Salaire', 'Affaires'))->nullable();
			$table->enum('categorie', array('Résident', 'Étudiant', 'Non-résident', 'Personnepolitiquementexposèe(PPE)', 'Homme/Femmeaffaires'))->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('comptes');
	}
}