<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('residenceCountry')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->foreign('client')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services_comptes', function(Blueprint $table) {
			$table->foreign('compte')->references('id')->on('comptes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services_comptes', function(Blueprint $table) {
			$table->foreign('service_financier')->references('id')->on('services_financiers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('acces_comptes', function(Blueprint $table) {
			$table->foreign('compte')->references('id')->on('comptes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('acces_comptes', function(Blueprint $table) {
			$table->foreign('acces_service')->references('id')->on('acces_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('suscriptions_types_comptes', function(Blueprint $table) {
			$table->foreign('compte')->references('id')->on('comptes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('suscriptions_types_comptes', function(Blueprint $table) {
			$table->foreign('type_compte')->references('id')->on('types_comptes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('countryoflssue')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('compte')->references('id')->on('comptes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parents', function(Blueprint $table) {
			$table->foreign('client')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_residenceCountry_foreign');
		});
		Schema::table('comptes', function(Blueprint $table) {
			$table->dropForeign('comptes_client_foreign');
		});
		Schema::table('services_comptes', function(Blueprint $table) {
			$table->dropForeign('services_comptes_compte_foreign');
		});
		Schema::table('services_comptes', function(Blueprint $table) {
			$table->dropForeign('services_comptes_service_financier_foreign');
		});
		Schema::table('acces_comptes', function(Blueprint $table) {
			$table->dropForeign('acces_comptes_compte_foreign');
		});
		Schema::table('acces_comptes', function(Blueprint $table) {
			$table->dropForeign('acces_comptes_acces_service_foreign');
		});
		Schema::table('suscriptions_types_comptes', function(Blueprint $table) {
			$table->dropForeign('suscriptions_types_comptes_compte_foreign');
		});
		Schema::table('suscriptions_types_comptes', function(Blueprint $table) {
			$table->dropForeign('suscriptions_types_comptes_type_compte_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_countryoflssue_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_compte_foreign');
		});
		Schema::table('parents', function(Blueprint $table) {
			$table->dropForeign('parents_client_foreign');
		});
	}
}