<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AccesCompte extends Eloquent {

	protected $table = 'acces_comptes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function accesService()
	{
		return $this->belongsTo('AccesService', 'acces_service');
	}

	public function compte()
	{
		return $this->belongsTo('Compte', 'compte');
	}

}