<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Document extends Eloquent {

	protected $table = 'documents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function country()
	{
		return $this->belongsTo('Country', 'countryoflssue');
	}

	public function compte()
	{
		return $this->belongsTo('Compte', 'compte');
	}

}