<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Faq', function(Blueprint $table) {
			$table->foreign('uid_question')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Faq', function(Blueprint $table) {
			$table->foreign('uid_answer')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('FeedbackTicket', function(Blueprint $table) {
			$table->foreign('uid_creator')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Feedback', function(Blueprint $table) {
			$table->foreign('uid_reply')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Feedback', function(Blueprint $table) {
			$table->foreign('id_ticket')->references('id')->on('FeedbackTicket')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Faq', function(Blueprint $table) {
			$table->dropForeign('Faq_uid_question_foreign');
		});
		Schema::table('Faq', function(Blueprint $table) {
			$table->dropForeign('Faq_uid_answer_foreign');
		});
		Schema::table('FeedbackTicket', function(Blueprint $table) {
			$table->dropForeign('FeedbackTicket_uid_creator_foreign');
		});
		Schema::table('Feedback', function(Blueprint $table) {
			$table->dropForeign('Feedback_uid_reply_foreign');
		});
		Schema::table('Feedback', function(Blueprint $table) {
			$table->dropForeign('Feedback_id_ticket_foreign');
		});
	}
}