<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBankAccountsTable extends Migration {

	public function up()
	{
		Schema::create('bank_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('description')->nullable();
			$table->string('agency')->nullable();
			$table->string('number')->nullable();
			$table->integer('wallet')->nullable();
			$table->integer('bank_id')->unsigned();
			$table->integer('benefeciary_id')->unsigned();
			$table->timestamps();
			$table->string('title', 10);
		});
	}

	public function down()
	{
		Schema::drop('bank_accounts');
	}
}