<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('agents', function(Blueprint $table) {
			$table->foreign('object_id')->references('id')->on('objects')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->foreign('object_id')->references('id')->on('objects')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('object_id')->references('id')->on('objects')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attributes_user', function(Blueprint $table) {
			$table->foreign('Object_id')->references('id')->on('objects')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attributes_user', function(Blueprint $table) {
			$table->foreign('attribute_definition_id')->references('id')->on('attribute_definitions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attributes_agent', function(Blueprint $table) {
			$table->foreign('Object_id')->references('id')->on('objects')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attributes_agent', function(Blueprint $table) {
			$table->foreign('attribute_definition_id')->references('id')->on('attribute_definitions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attributes_devices', function(Blueprint $table) {
			$table->foreign('Object_id')->references('id')->on('objects')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('attributes_devices', function(Blueprint $table) {
			$table->foreign('attribute_definition_id')->references('id')->on('attribute_definitions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('agents', function(Blueprint $table) {
			$table->dropForeign('agents_object_id_foreign');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->dropForeign('devices_object_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_object_id_foreign');
		});
		Schema::table('attributes_user', function(Blueprint $table) {
			$table->dropForeign('attributes_user_Object_id_foreign');
		});
		Schema::table('attributes_user', function(Blueprint $table) {
			$table->dropForeign('attributes_user_attribute_definition_id_foreign');
		});
		Schema::table('attributes_agent', function(Blueprint $table) {
			$table->dropForeign('attributes_agent_Object_id_foreign');
		});
		Schema::table('attributes_agent', function(Blueprint $table) {
			$table->dropForeign('attributes_agent_attribute_definition_id_foreign');
		});
		Schema::table('attributes_devices', function(Blueprint $table) {
			$table->dropForeign('attributes_devices_Object_id_foreign');
		});
		Schema::table('attributes_devices', function(Blueprint $table) {
			$table->dropForeign('attributes_devices_attribute_definition_id_foreign');
		});
	}
}