<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateObjectTable extends Migration {

	public function up()
	{
		Schema::create('object', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 128);
			$table->integer('object_category_id')->unsigned();
			$table->integer('manufacture_country_id')->unsigned();
			$table->decimal('calibre')->nullable();
			$table->string('calibre_note', 128)->nullable();
			$table->decimal('length')->nullable();
			$table->string('length_note', 128)->nullable();
			$table->decimal('height')->nullable();
			$table->string('height_note', 128)->nullable();
			$table->decimal('weight')->nullable();
			$table->decimal('weight_deviation')->nullable();
			$table->integer('explosive_id')->unsigned()->nullable();
			$table->decimal('explosive_weight')->nullable();
			$table->string('explosive_note', 128)->nullable();
			$table->decimal('operating_force')->nullable();
			$table->string('operating_force_note', 128)->nullable();
			$table->text('note')->nullable();
			$table->boolean('ck_original_assesment')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('object');
	}
}