<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('object', function(Blueprint $table) {
			$table->foreign('object_category_id')->references('id')->on('object_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('object', function(Blueprint $table) {
			$table->foreign('manufacture_country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('object', function(Blueprint $table) {
			$table->foreign('explosive_id')->references('id')->on('explosive')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('object_category', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('object_category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('object_image', function(Blueprint $table) {
			$table->foreign('object_id')->references('id')->on('object')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hardware', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hardware_component', function(Blueprint $table) {
			$table->foreign('hardware_id')->references('id')->on('hardware')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('object', function(Blueprint $table) {
			$table->dropForeign('object_object_category_id_foreign');
		});
		Schema::table('object', function(Blueprint $table) {
			$table->dropForeign('object_manufacture_country_id_foreign');
		});
		Schema::table('object', function(Blueprint $table) {
			$table->dropForeign('object_explosive_id_foreign');
		});
		Schema::table('object_category', function(Blueprint $table) {
			$table->dropForeign('object_category_parent_id_foreign');
		});
		Schema::table('object_image', function(Blueprint $table) {
			$table->dropForeign('object_image_object_id_foreign');
		});
		Schema::table('hardware', function(Blueprint $table) {
			$table->dropForeign('hardware_location_id_foreign');
		});
		Schema::table('hardware_component', function(Blueprint $table) {
			$table->dropForeign('hardware_component_hardware_id_foreign');
		});
	}
}