<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePageSectionsTable extends Migration {

	public function up()
	{
		Schema::create('page_sections', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('page_id')->unsigned();
			$table->bigInteger('section_id')->unsigned();
			$table->mediumInteger('sort');
			$table->boolean('status')->default(1);
			$table->timestamp('published_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('page_sections');
	}
}