<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateButtonsTable extends Migration {

	public function up()
	{
		Schema::create('buttons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('url')->nullable();
			$table->bigInteger('entity_id');
			$table->string('entity_type');
			$table->mediumInteger('sort')->nullable();
			$table->boolean('status')->default(0);
			$table->timestamps();
			$table->enum('btn_style', array('default', 'solid'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('buttons');
	}
}