<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Job extends Eloquent {

	protected $table = 'jobs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'short_description', 'description', 'job_type', 'remote', 'location', 'country_id', 'section_id', 'published_at');

	public function section()
	{
		return $this->belongsTo('Section', 'section_id');
	}

	public function country()
	{
		return $this->belongsTo('Country');
	}

}