<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('translations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('entity_id');
			$table->string('entity_type');
			$table->enum('locale', array('en', 'ar'));
			$table->string('field');
			$table->string('value');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('translations');
	}
}