<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectionListsTable extends Migration {

	public function up()
	{
		Schema::create('section_lists', function(Blueprint $table) {
			$table->increments('id');
			$table->mediumInteger('section_id');
			$table->string('title')->nullable();
			$table->string('description')->nullable();
			$table->boolean('status')->default(1);
			$table->timestamp('published_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('section_lists');
	}
}