<?php

namespace App\Modules\Secretariat\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MeetingDiscussionPoint extends Eloquent {

	protected $table = 'meeting_discussion_points';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('content', 'meeting_id');

	public function meeting()
	{
		return $this->belongsTo('App\Modules\Secretariat\Entities\Meeting');
	}

}