<?php

namespace App\Modules\CustomerService\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Message extends Eloquent {

	protected $table = 'messages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('customer_name', 'phone', 'identification_number', 'customer_service_id', 'type', 'content');

	public function customer_service()
	{
		return $this->belongsTo('App\Modules\CustomerService\Entities\CustomerService', 'customer_service_id');
	}

}