<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisitsTable extends Migration {

	public function up()
	{
		Schema::create('visits', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('date');
			$table->integer('management_id')->unsigned();
			$table->string('type', 150);
			$table->text('note')->nullable();
			$table->enum('status', array('new', 'underway', 'finished', 'canceled'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('visits');
	}
}